#! /bin/sh
# This script integrates FabuleTech library to VMware Horizon Client
#

set -e

LIB_PATH="/opt/ftplugins/lib/ftblastbr.so"
VMWARE_CLIENT_DIR="/usr/lib/vmware/rdpvcbridge"
VMWARE_CLIENT_CONFIG_FILE="freerdp_plugins.conf"
LIB_NAME="ftblastbr.so"

usage () {
echo "\
Usage: $(basename $0) -i|-u,
where:
        -i      - Install VMware Blast support
        -u      - Uninstall VMware Blast support
        -h      - Show help"
}

enable_plugin () {
sed \
'$ a\
ftblastbr=enabled' \
"$1" > "$1".tmp
cat "$1".tmp > "$1"
rm -f "$1".tmp
}

disable_plugin () {
sed \
-e '/ftblastbr/ d' \
"$1" > "$1".tmp
cat "$1".tmp > "$1"
rm -f "$1".tmp
}

case "$1" in
"-i")
	if [ -d "$VMWARE_CLIENT_DIR" ]
	then
		rm -f "$VMWARE_CLIENT_DIR/$LIB_NAME"
		disable_plugin "$VMWARE_CLIENT_DIR/$VMWARE_CLIENT_CONFIG_FILE"
		ln -s "$LIB_PATH" "$VMWARE_CLIENT_DIR/$LIB_NAME"
		enable_plugin "$VMWARE_CLIENT_DIR/$VMWARE_CLIENT_CONFIG_FILE"
		echo "Installed for VMware Horizon Client"
	else
		echo "Directory $VMWARE_CLIENT_DIR does not exists, probably VMware Horizon Client is not installed"
		exit 1
	fi
	;;
"-u")
	if [ -d "$VMWARE_CLIENT_DIR" ]
	then
		rm -f "$VMWARE_CLIENT_DIR/$LIB_NAME"
		disable_plugin "$VMWARE_CLIENT_DIR/$VMWARE_CLIENT_CONFIG_FILE"
		echo "Uninstalled for VMware Horizon Client"
	else
		echo "Directory $VMWARE_CLIENT_DIR does not exists, probably VMware Horizon Client is not installed"
		exit 1
	fi
	;;
"-h")
	usage
	;;
*)
	usage
	;;
esac

